#---------------
# toolbar_configure.tcl.tcl
#---------------
# William J Giddings
# 08/12/07
#---------------

#!/bin/sh \
exec tclsh  "$0" "$@"

package require Gnocl

# pb stuff straight from the docs..

set toolBar [gnocl::toolBar -style icons]
$toolBar add item -text "%#Quit" -onClicked exit
$toolBar add space
$toolBar add checkItem -text "%#Underline" -variable underline
$toolBar add space
$toolBar add radioItem -text "%#JustifyLeft" -variable justify -onValue left
$toolBar add radioItem -text "%#JustifyRight" -variable justify -onValue right

# wjg stuff

$toolBar add space

# add a toolbar button
# double clicking this button will provide a popup menu
# select a new highlighting colour and the button icon should change!
set ::tmp [$toolBar add item \
        -icon "%/button_highlighter_green.png" \
        -tooltip "highlighter" \
        -onButtonPress {
            puts %w
            switch %t {
                button2Press {
                    $::menu popup
                }
                default {
                  puts "%w %t %s %x %y"
                  $::tmp configure -icon "%%/button_highlighter_$::highlightClr.png"
               }
            }
        }]

set ::menu [gnocl::menu -title "menu" -tearoff 0]
    
$::menu add [gnocl::menuItem -icon "%/highlighter_green.png" -onClicked {
    set ::highlightClr green
    puts "A $::tmp $::highlightClr"
    $::tmp configure -icon "%%/button_highlighter_green.png" }]
    
$::menu add [gnocl::menuItem -icon "%/highlighter_pink.png" -onClicked {
    set ::highlightClr pink
    puts "B $::tmp $::highlightClr"
    $::tmp configure -icon "%%/button_highlighter_pink.png" }]

$::menu add [gnocl::menuItem -icon "%/highlighter_orange.png" -onClicked {
    set ::highlightClr orange
    puts "C $::tmp $::highlightClr"
    $::tmp configure -icon "%%/button_highlighter_orange.png" }]
    
$::menu add [gnocl::menuItem -icon "%/highlighter_blue.png" -onClicked {
    set ::highlightClr blue
    puts "D $::tmp $::highlightClr"
    $::tmp configure -icon "%%/highlighter_blue.png" }]
    
$::menu add [gnocl::menuItem -icon "%/highlighter_yellow.png" -onClicked {
    set ::highlightClr yellow
    puts "E $::tmp $::highlightClr"
    $::tmp configure -icon "%%/button_highlighter_yellow.png" }]
    
$::menu add [gnocl::menuItem -icon "%/highlighter_cyan.png" -onClicked {
    set ::highlightClr cyan
    puts "F $::tmp $::highlightClr"
    $::tmp configure -icon "%%/button_highlighter_cyan.png" }]

$::tmp configure -icon "%%/button_highlighter_pink.png"

gnocl::window -title "ToolBar" -child $toolBar


    
